/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model.input;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.mapgen.model.RockGroup;
import technology.rocketjump.undermount.mapgen.model.input.GemType;
import technology.rocketjump.undermount.mapgen.model.input.OreType;
import technology.rocketjump.undermount.mapgen.model.input.RockType;
import technology.rocketjump.undermount.mapgen.model.input.ShrubType;
import technology.rocketjump.undermount.mapgen.model.input.TreeType;

public class GameMapGenerationParams {
    private final int targetWidth;
    private final int targetHeight;
    private float heightMapVariance = 1.0f;
    private float heightMapRoughness = 0.6f;
    private float ratioOfMountains = 0.5f;
    private float requiredTotalOreRatio = 0.12f;
    private float requiredTotalGemRatio = 0.01f;
    private float ratioOfFruitingShrubs = 0.08f;
    private List<OreType> oreTypeList = new ArrayList<OreType>();
    private float totalOfOreRequirementAmounts = 0.0f;
    private int minOreVeinLength = 5;
    private int maxOreVeinLength = 50;
    private float oreVeinWidthVariance = 4.0f;
    private Map<RockGroup, List<RockType>> rockTypeMap = new EnumMap<RockGroup, List<RockType>>(RockGroup.class);
    private Map<RockGroup, List<GemType>> gemTypeMap = new EnumMap<RockGroup, List<GemType>>(RockGroup.class);
    private final List<TreeType> treeTypes = new ArrayList<TreeType>();
    private final List<ShrubType> shrubTypes = new ArrayList<ShrubType>();

    public GameMapGenerationParams(int targetWidth, int targetHeight) {
        this.targetWidth = targetWidth;
        this.targetHeight = targetHeight;
        for (RockGroup rockGroup : RockGroup.values()) {
            this.rockTypeMap.put(rockGroup, new ArrayList());
            this.gemTypeMap.put(rockGroup, new ArrayList());
        }
    }

    public void addOreRequirement(OreType oreType) {
        this.oreTypeList.add(oreType);
        this.totalOfOreRequirementAmounts += oreType.getWeighting();
    }

    public List<OreType> getOreTypeList() {
        return this.oreTypeList;
    }

    public int getTargetWidth() {
        return this.targetWidth;
    }

    public int getTargetHeight() {
        return this.targetHeight;
    }

    public float getHeightMapVariance() {
        return this.heightMapVariance;
    }

    public void setHeightMapVariance(float heightMapVariance) {
        this.heightMapVariance = heightMapVariance;
    }

    public float getHeightMapRoughness() {
        return this.heightMapRoughness;
    }

    public void setHeightMapRoughness(float heightMapRoughness) {
        this.heightMapRoughness = heightMapRoughness;
    }

    public float getRatioOfMountains() {
        return this.ratioOfMountains;
    }

    public void setRatioOfMountains(float ratioOfMountains) {
        this.ratioOfMountains = ratioOfMountains;
    }

    public float getRequiredTotalOreRatio() {
        return this.requiredTotalOreRatio;
    }

    public float getRequiredTotalGemRatio() {
        return this.requiredTotalGemRatio;
    }

    public float getTotalOfOreRequirementAmounts() {
        return this.totalOfOreRequirementAmounts;
    }

    public int getMinOreVeinLength() {
        return this.minOreVeinLength;
    }

    public void setMinOreVeinLength(int minOreVeinLength) {
        this.minOreVeinLength = minOreVeinLength;
    }

    public int getMaxOreVeinLength() {
        return this.maxOreVeinLength;
    }

    public void setMaxOreVeinLength(int maxOreVeinLength) {
        this.maxOreVeinLength = maxOreVeinLength;
    }

    public float getOreVeinWidthVariance() {
        return this.oreVeinWidthVariance;
    }

    public void addRockTypes(RockType ... rockTypes) {
        for (RockType rockType : rockTypes) {
            this.rockTypeMap.get((Object)rockType.getRockGroup()).add(rockType);
        }
    }

    public void addGemTypes(GemType ... gemTypes) {
        for (GemType gemType : gemTypes) {
            this.gemTypeMap.get((Object)gemType.getRockGroup()).add(gemType);
        }
    }

    public List<RockType> getRockTypes(RockGroup group) {
        return this.rockTypeMap.get((Object)group);
    }

    public List<GemType> getGemTypes(RockGroup group) {
        return this.gemTypeMap.get((Object)group);
    }

    public List<TreeType> getTreeTypes() {
        return this.treeTypes;
    }

    public List<ShrubType> getShrubTypes() {
        return this.shrubTypes;
    }

    public float getRatioOfFruitingShrubs() {
        return this.ratioOfFruitingShrubs;
    }

    public void setRatioOfFruitingShrubs(float ratioOfFruitingShrubs) {
        this.ratioOfFruitingShrubs = ratioOfFruitingShrubs;
    }
}

